clear all;close all;clc
% Eyelink data were recorded at 1000 Hz
% Trials lasted up to 1 s after the video ended

ppvalid=[1:20 23 25:36];

create_mat = 0; % if 1, then save .mat file from Eyelink .txt exports
if create_mat==1
    
    for i=1:length(ppvalid)
        x = tdfread(['Data\p_' num2str(ppvalid(i)) '.txt']);
        X=[x.TRIAL_INDEX double(string(x.RIGHT_GAZE_X)) double(string(x.RIGHT_GAZE_Y))  double(string(x.RIGHT_PUPIL_SIZE))  double(string(x.VIDEO_FRAME_INDEX))];
        save(['Data\X' num2str(ppvalid(i)) '.mat'],'X')
    end
end

[Xa,Ya,Pa,Ba]=deal(NaN(34,45,14100));
Fa=NaN(34,45,25,7);
Sa=NaN(34,45,25,7);
ppvalid=[1:20 23:36];
for i=1:length(ppvalid) % loop over participants
    pp=ppvalid(i);
    if pp~=24 % participant has response data but no eye-tracking data
        load(['Data\X' num2str(pp) '.mat'])
        for trial=1:45
           
            indexes_of_trial=find(X(:,1)==trial*2);
            data_of_trial=X(indexes_of_trial,:);
            data_of_trial=data_of_trial(find(data_of_trial(:,5)==1,1,'first'):end,:); % start with first video frame
            
            Xe=data_of_trial(:,2);
            Ye=data_of_trial(:,3);
            Pe=data_of_trial(:,4);
            Xe(1:2:end*2)=Xe;Xe(2:2:end+1)=Xe(1:2:end); % double the sampling rate since the function ProcessEyes8 was developed for 2000 Hz
            Ye(1:2:end*2)=Ye;Ye(2:2:end+1)=Ye(1:2:end);
            Pe(1:2:end*2)=Pe;Pe(2:2:end+1)=Pe(1:2:end);
            Pe(Pe<=0)=NaN;
            if sum(~isnan(Xe))>1 && sum(~isnan(Ye))>1 && sum(~isnan(Pe))>1 % there should be at least some data
                
                try
                    [f,s,x,y,pd,bm]=FixationFilterEyelink1000v106(Xe,Ye,Pe); % filter the eye-tracking data

                    if ~isnan(f(1,1)) % if there are fixations
                        for i2=1:size(f,1) % loop over fixations
                            f(i2,7)=identify_location(f(i2,5),f(i2,6)); % identify fixation AOI number
                        end
                    end
                    Xa(i,trial,1:length(x))=x;
                    Ya(i,trial,1:length(y))=y;
                    Ba(i,trial,1:length(bm))=bm;
                    Pa(i,trial,1:length(pd))=pd;
                    Fa(i,trial,1:size(f,1),1:size(f,2))=f;
                    Sa(i,trial,1:size(s,1),1:size(s,2))=s;
                catch error
                    disp([i trial])
                end
                
            end
            
        end
    end
end

save('AllgazeJan2023','Xa','Ya','Ba','Pa','Fa','Sa')
